#include "stdafx.h"
#include <stdio.h>
#include "asmutils.h"
#include <stdarg.h>

unsigned int line = 0;
const unsigned int MAX_TOKEN_LENGTH = 50;

//****************************************************************************************************************
//fce pro spojeni dvou retezcu
//****************************************************************************************************************
char*	stringConcat(char* str1,...)
{
	int			buffer_size = 0;
	char*		ptr = str1;
	char*		buffer = NULL;
	int			offset = 0;
	va_list		curr_argument;

	va_start(curr_argument,str1);

	while (ptr != NULL)
	{
		buffer_size += (int)strlen(ptr);
		ptr = va_arg(curr_argument,char*);
	}

	va_end(curr_argument);

	//mame spoctenou delku
	
	buffer = new char[buffer_size + 1];

	va_start(curr_argument,str1);
	
	ptr = str1;

	while (ptr != NULL)
	{
		strcpy(buffer + offset,ptr);
		offset += (int)strlen(ptr);
		ptr = va_arg(curr_argument,char*);
	}

	va_end(curr_argument);

	*(buffer + offset) = 0;

	return buffer;
}
//****************************************************************************************************************
//fce pro zapsani retezce ukonceneho nulou do souboru
//****************************************************************************************************************
void	WriteZString(char* str, FILE* f)
{
	char zero = 0;

	fwrite(str,strlen(str) * sizeof(char),1,f);
	fwrite(&zero,sizeof(char),1,f);
}
//****************************************************************************************************************
//fce pro precteni symbolu ze souboru
//****************************************************************************************************************
char*	getToken(FILE* f)
{
	char*	token = NULL;
	char*	temp;
	char	chr;
	int		iRet;
	int		i = 0;
	int		iCurrMult = 0;

	/*preskoceni vsech mezer, tabulatoru a pocitani nove radky*/
	do
	{
		iRet = (int)fread(&chr,sizeof(char),1,f);

		if (iRet == 1 && chr == '\n')	//pokud cteni probehlo uspesne a znak je novy radek
			line++;						//tak pocitej novy radek

	}
	while ((iRet == 1) && ((chr == ' ') || (chr == '\t') || (chr == '\n')));	//opakuj dokud ctes meyeru, tabulator nebo novy radek

	if (iRet == 0)
		return NULL;

	do
	{
		//nejdriv kontrola velikosti pameti pro ulozeni retezce a pripadna alokace
		if (i >= int(iCurrMult * MAX_TOKEN_LENGTH))
		{
			iCurrMult++;									//zvetseni nasobitele o jednu
			temp = new char[iCurrMult * MAX_TOKEN_LENGTH];	//zvtseni alokovaneho pole bytu o MAX_TOKEN_LENGTH bajtu
			if (token)
				strcpy(temp,token);								//prekopirovani uz nacteneho retezce do noveho pole
			token = temp;									//nastaveni ukazatele na pole nove	
		}

		token[i] = chr;										//uloz nacteny znak do retezce
		iRet = (int)fread(&chr,sizeof(char),1,f);				//cti dalsi znak ze souboru
		if ((iRet == 1) && (chr == '\n'))					//pokud je to novy radek, pocitej cislo radku
			line++;

		i++;												//zvys pocitadlo ctenych znaku o jedna
	}
	while ((iRet == 1) && (chr != ' ') && (chr != '\t') && (chr != '\n'));	//opakuj dokud ctes jine znaky nez mezeru, tabulator nebo novy radek
	
	token[i] = 0;	//na konec retezce dej nulu
	return token;	//vrat nacteny symbol
}

//****************************************************************************************************************
//fce pro precteni symbolu ktery je uzavren v uvozovkach, pricemz uvozovky odstranime
//****************************************************************************************************************
char*	getStringToken(FILE* f)
{
	char*	token = NULL;
	char*	temp;
	char	chr;
	int		iRet;
	int		i = 0;
	int		iCurrMult = 0;

	/*preskoceni vsech mezer, tabulatoru a pocitani nove radky*/
	do
	{
		iRet = (int)fread(&chr,sizeof(char),1,f);

		if (iRet == 1 && chr == '\n')	//pokud cteni probehlo uspesne a znak je novy radek
			line++;						//tak pocitej novy radek

	}
	while ((iRet == 1) && (chr == '"') || (chr == '\t') || (chr == '\n'));	//opakuj dokud ctes meyeru, tabulator nebo novy radek
	
	if (iRet == 0)
		return NULL;

	do
	{
		//nejdriv kontrola velikosti pameti pro ulozeni retezce a pripadna alokace
		if (i >= int(iCurrMult * MAX_TOKEN_LENGTH))
		{
			iCurrMult++;									//zvetseni nasobitele o jednu
			temp = new char[iCurrMult * MAX_TOKEN_LENGTH];	//zvtseni alokovaneho pole bytu o MAX_TOKEN_LENGTH bajtu
			if (token)
				strcpy(temp,token);								//prekopirovani uz nacteneho retezce do noveho pole
			token = temp;									//nastaveni ukazatele na pole nove	
		}

		if (chr != '"')										//pokud neni je uvozovka
		{													//tak uloz znak, tim vlastne odstranime uvozovky
			token[i] = chr;									//uloz nacteny znak do retezce
			i++;											//zvys pocitadlo ctenych znaku o jedna
		}
		iRet = (int)fread(&chr,sizeof(char),1,f);				//cti dalsi znak ze souboru
		if ((iRet == 1) && (chr == '\n'))					//pokud je to novy radek, pocitej cislo radku
			line++;
	}
	while ((iRet == 1) && (chr != '"') && (chr != '\t') && (chr != '\n'));	//opakuj dokud ctes jine znaky nez mezeru, tabulator nebo novy radek
	
	token[i] = 0;	//na konec retezce dej nulu
	return token;	//vrat nacteny symbol
}
